$(function() {

	$.widget( "common.quantity", {
		defaultElement: "<div>",
		
		options: {
			min: 0,
			max: null,
			value: 1,
			visible: true,
			enabled: true
		},
		
		_lastValue: null,
		_spinnerTimeout: null,
		
		show: function(show){
			this.element.css('visibility', show ? 'visible' : 'hidden');
		},
		
		enable: function(enable){
			enable ? this._control.enable() : this._control.disable();
		},
		
		value: function( value ) {
			// No value passed, act as a getter.
			if ( value === undefined ) {
				return this._control.value();
			} else {
				this._control.value(value);
			}
		},
		
		initValue: function(value){
			this.ignoreEvent = true;
			this.value(value);
			this.ignoreEvent = false;
		},
		
		initMin: function(value){
			this._control.option('min', value);
		},
		
		initMax: function(value){
			this._control.option('max', value);
		},
		
		_create: function(){
			this.element.addClass('common-quantity');
			
			var input = $('<input>')
				.appendTo(this.element);
			
			this._control = input.spinnerEx({
				min: this.options.min,
				max: this.options.max,
				incremental: false,
				numberFormat: "n",
				step: 1,
				
				spin: $.proxy(this._spin, this),
				change: $.proxy(this._change, this)
			}).spinnerEx('instance');
			this._control.element.css('width','100%');
			
			this.initValue(this.options.value);
			
			this.show(this.options.visible);
			this.enable(this.options.enabled);
			
		},
		
		_spin: function(event, ui){
			if (this.ignoreEvent) return;
			
			var value = ui.value;
			if (value != this._lastValue){
				this._lastValue = value;
				//set a little delay, saves time when user spins multiple times in a row
				if (this._spinnerTimeout) clearTimeout(this._spinnerTimeout);
				this._spinnerTimeout = setTimeout($.proxy(function(){
					this._trigger( "changed", null, { value: this._lastValue });
					this._spinnerTimeout = null;
				}, this), 500);
				
			}
		},
		
		_change: function(event, ui){
			if (this.ignoreEvent) return;
		
			var value = this._control.value();
			if (this.options.max && (value > this.options.max)){
				// value exceeds maximum
				value = this.options.max;
				this._control.value(value);
				return;
			}
			if (this.options.min && (value < this.options.min)){
				// value exceeds minimum
				value = this.options.min;
				this._control.value(value)
				return;
			}
			
			if (value != this._lastValue){
				this._lastValue = value;
				this._trigger( "changed", event, { value:this._lastValue });
			}
		}
		
	});
	
	$.widget( "common.spinnerEx", $.ui.spinner, {
	
		// jquery zaokrouhluje na hodnoty, na ktere je mozne skocit pri spinu
		// např. min = 0.5, value = 1, step = 1
		// radek zakomentovany jako fix, zaokrouhli hodnotu 1 na 1.5
		// a to opravdu nechceme
		_adjustValue: function( value ) {
			var base, aboveMin,
				options = this.options;

			// make sure we're at a valid step
			// - find out where we are relative to the base (min or 0)
			base = options.min !== null ? options.min : 0;
			aboveMin = value - base;
			// - round to the nearest step
			/** fix aboveMin = Math.round(aboveMin / options.step) * options.step; **/
			// - rounding is based on 0, so adjust back to our base
			value = base + aboveMin;

			// fix precision from bad JS floating point math
			value = parseFloat( value.toFixed( this._precision() ) );

			// clamp the value
			if ( options.max !== null && value > options.max) {
				return options.max;
			}
			if ( options.min !== null && value < options.min ) {
				return options.min;
			}

			return value;
		}
	
	});

    $.widget( "common.iconselectmenu", $.ui.selectmenu, {
		
		_setHtml: function(element, value){
			element.html('');
			$(value).appendTo(element);
		},
		
		_select: function( item, event ) {
			this._superApply( arguments );
			this._setHtml( this.buttonText, item.element.html() );
		},
		
		_renderItem: function( ul, item ) {
		
			var li = $( "<li>");
			
			if ( item.disabled ) {
			  li.addClass( "ui-state-disabled" );
			}
			
			this._setHtml(li, item.element.html());
	 
			return li.appendTo( ul );
		},
		
		_drawButton: function() {
			this._superApply( arguments );
			
			var item = this.element.find( "option:selected" );
			this._setHtml( this.buttonText, item.html());
		},
		
		refresh: function() {
			this._superApply( arguments );
			this._setHtml( this.buttonText, this._getSelectedItem().html() );
		}
    });

	$.widget( "common.expander", {
		defaultElement: "<div>",

		options: {
			parent: null,
			name: "default name"
		},

		expanded: true,

		//public functions
		expand: function(event){
			if (this._trigger( "expand", event, this)){
				this.expanded = true;
				$(this.element).toggleClass('expanded',this.expanded);
			}
		},

		collapse: function(event){
			if (this._trigger( "collapse", event, this)){
				this.expanded = false;
				$(this.element).toggleClass('expanded',this.expanded);

			}
		},

		//private functions
		_create: function() {
			var self = this;
			this.element.addClass( "common-expander" );
			$(this.element).toggleClass('expanded',this.expanded);

			if (this.options.appendTo){
				this.element.appendTo($(this.options.appendTo));
			}

			$('<img src="' + QIPortalAPI.appPath + 'Modules/QIShop/images/goodsSetExpand.png">')
				.addClass('common-expander-icon')
				.prependTo(this.element);

			// listen to clicks event
			this._on(this.element, {
				'click': function(event){
					self.expanded ? self.collapse(event) : self.expand(event);
				}
			});

			this.element.disableSelection();
		}
		
	});
});